<?php

/**************************************************************
 * CGI's  MailForm ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

// 要素型: 整数
define('VAR_TYPE_INT', 1);
// 要素型: 浮動小数点数
define('VAR_TYPE_FLOAT', 2);
// 要素型: 文字列
define('VAR_TYPE_STRING', 3);
// 要素型: 日付
define('VAR_TYPE_DATETIME', 4);
// 要素型: 真偽値
define('VAR_TYPE_BOOLEAN', 5);
// 要素型: ファイル
define('VAR_TYPE_FILE', 6);
// 正規表現パターン
define("PTN_MAIL", '/^([0-9a-z_]|\-|\.|\+)+@(([0-9a-z_]|\-)+\.)+[a-z]{2,6}$/i');
define("PTN_URL", '/^(https?|ftp)(:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)$/i');
define("PTN_PASS", '/^[0-9a-z]+$/i');
define("PTN_COLOR", '/^[0-9a-f]{6}$/i');
/**
 *  フォーム値をフォーム定義に追加
 *
 *  @return void
 */
function importForms($formDef)
{
    foreach ($formDef as $key => $value) {
        // フォーム定義に値追加
        $formDef[$key]['value'] = '';
        if (isset($_REQUEST[$key])) {
            $formDef[$key]['value'] = $_REQUEST[$key];
        }

        $type = is_array($value['type']) ? $value['type'][0] : $value['type'];

        // ファイルの場合
        if ($type == VAR_TYPE_FILE) {
            // 配列の場合、ファイルごとの情報にして格納
            if (is_array($value['type'])) {
                if ($_FILES[$key]) {
                    $_FILES[$key]['tmp_name'] = toArray($_FILES[$key]['tmp_name']);
                    foreach ($_FILES[$key]['tmp_name'] as $k => $v) {
                        $formDef[$key]['value'][$k]['tmp_name'] = $v;
                        $formDef[$key]['value'][$k]['name']  = $_FILES[$key]['name'][$k];
                        $formDef[$key]['value'][$k]['type']  = $_FILES[$key]['type'][$k];
                        $formDef[$key]['value'][$k]['error'] = $_FILES[$key]['error'][$k];
                        $formDef[$key]['value'][$k]['size']  = $_FILES[$key]['size'][$k];
                    }
                }
            } else {
                $formDef[$key]['value'] = $_FILES[$key];
            }
        }
    }
    return $formDef;
}

/**
 *  validateしてエラーをセット
 *
 *  @return int エラーの数
 */
function validate($formDef, $keys = "")
{

    // エラー格納用
    $errors = [];

    $keys = toArray($keys);

    // キーが指定されている場合はキーのみチェックとするため他は除去
    if ($keys && count($keys) > 0) {
        foreach ($keys as $k) {
            foreach ($formDef as $key => $value) {
                if ($key == $k) {
                    $new[$key] = $value;
                }
            }
        }
        if ($new) {
            $formDef = $new;
        } else {
            return 0;
        }
    }

    // フォーム定義の値をチェック
    foreach ($formDef as $key => $def) {

        // タイプ取得
        $type = is_array($def['type']) ? $def['type'][0] : $def['type'];


        // 値の存在を確認
        $value_exists = 0;

        // 値が空ではない
        if ($def['value'] != '') {
            // 配列の場合
            if (is_array($def['type'])) {
                $def['value'] = toArray($def['value']);
                if ($type == VAR_TYPE_FILE) {
                    // ファイルの場合ファイルの存在までチェック
                    foreach ($def['value'] as $k => $v) {
                        if ($v['tmp_name'] != '' && is_file($v['tmp_name'])) {
                            $value_exists = 1;
                            break;
                        }
                    }
                } else {
                    // ファイル以外
                    foreach ($def['value'] as $k => $v) {
                        if ($v != '') {
                            $value_exists = 1;
                            break;
                        }
                    }
                }
            } else {
                if ($type == VAR_TYPE_FILE) {
                    // ファイルの場合ファイルの存在までチェック
                    if (is_file($def['value']['tmp_name'])) {
                        $value_exists = 1;
                    }
                } else {
                    // 配列でもなく、ファイルでもない場合、値が空ではない時点でOK
                    $value_exists = 1;
                }
            }
        }

        if ($value_exists == 0) {
            // 値が存在しなかった場合requiredのチェックのみ行う
            if ($def['required'] == true) {
                $errors[] = $def['name'].'を入力してください';
            }
        } else {

            // 値が存在した場合他のチェックを行う

            if (is_array($def['type'])) {
                // 配列
                foreach ($def['value'] as $k => $v) {
                    if ($error = _validate($def['name'], $v, $def)) {
                        $errors[] = $error;
                        break;
                    }
                }
            } else {
                // スカラー
                if ($error = _validate($def['name'], $def['value'], $def)) {
                    $errors[] = $error;
                }
            }
        }
    }

    return $errors;
}

/**
 *  フォーム値検証
 *
 *  @param  string  $name       フォーム項目名
 *  @param  mixed   $var        フォーム値
 *  @param  array   $def        フォーム値定義
 *  @return mixed エラー時：エラーテキスト / false
 */
function _validate($name, $var, $def)
{
    // 値が空ならエラーなし
    if ($var == '') {
        return false;
    }

    // タイプ取得
    $type = is_array($def['type']) ? $def['type'][0] : $def['type'];

    // type
    if ($type == VAR_TYPE_INT) {
        if (!is_null($var) && !preg_match('/^-?\d+$/', $var)) {
            return $name.'は整数を入力してください';
        }
    } elseif ($type == VAR_TYPE_FLOAT) {
        if (!is_null($var) && !preg_match('/^-?\d+$/', $var) && !preg_match('/^-?\d+\.\d+$/', $var)) {
            return $name.'は整数又は小数を入力してください';
        }
    } elseif ($type == VAR_TYPE_DATETIME) {
        $r = strtotime($var);
        if (!is_null($var) && ($r == -1 || $r === false)) {
            return $name.'は日付を入力してください';
        }
    } elseif ($type == VAR_TYPE_BOOLEAN) {
        if (!is_null($var) && ($var != "1" && $var != "0")) {
            return $name.'は 0 又は 1 を入力してください';
        }
    } elseif ($type == VAR_TYPE_STRING) {
        // nothing to do
    } elseif ($type == VAR_TYPE_FILE) {
        if (is_file($var['tmp_name']) && is_array($def['file_type'])) {
            $ok = 0;
            foreach ($def['file_type'] as $file_type) {
                if ($file_type == $var['type']) {
                    $ok = 1;
                    break;
                }
            }
            if ($ok == 0) {
                return $name.'に正しいファイルタイプを入力してください';
            }
        }
    }

    // min
    if ($type == VAR_TYPE_INT) {
        if (isset($def['min']) && !is_null($def['min']) && $var < $def['min']) {
            return $name.'は'.$def['min'].'以上を入力してください。';
        }
    } elseif ($type == VAR_TYPE_FLOAT) {
        if (isset($def['min']) && !is_null($def['min']) && $var < $def['min']) {
            return $name.'は'.$def['min'].'以上を入力してください。';
        }
    } elseif ($type == VAR_TYPE_DATETIME) {
        if (isset($def['min']) && !is_null($def['min'])) {
            $t_min = strtotime($def['min']);
            $t_var = strtotime($var);
            if ($t_var < $t_min) {
                return $name.'は'.$def['min'].'以上を入力してください。';
            }
        }
    } elseif ($type == VAR_TYPE_FILE) {
        if (is_file($var['tmp_name']) && isset($def['min']) && !is_null($def['min'])) {
            $min = (int)preg_replace('/K$/i', '000', $def['min']);
            if ($var['size'] < $min) {
                return $name.'は'.$def['min'].'Byte以上のファイルを入力してください。';
            }
        }
    } else {
        if (isset($def['min']) && !is_null($def['min']) && strlen($var) < $def['min']) {
            return $name.'は半角'.$def['min'].'（全角'.ceil($def['min'] / 2).'）文字以上を入力してください。';
        }
    }

    // max
    if ($type == VAR_TYPE_INT) {
        if (isset($def['max']) && !is_null($def['max']) && $var > $def['max']) {
            return $name.'は'.$def['max'].'以下を入力してください。';
        }
    } elseif ($type == VAR_TYPE_FLOAT) {
        if (!is_null($def['max']) && $var > $def['max']) {
            return $name.'は'.$def['max'].'以下を入力してください。';
        }
    } elseif ($type == VAR_TYPE_DATETIME) {
        if (isset($def['max']) && !is_null($def['max'])) {
            $t_min = strtotime($def['max']);
            $t_var = strtotime($var);
            if ($t_var > $t_min) {
                if ($test == false) {
                    return $name.'は'.$def['max'].'以下を入力してください。';
                }
            }
        }
    } elseif ($type == VAR_TYPE_FILE) {
        if (is_file($var['tmp_name']) && isset($def['max']) && !is_null($def['max'])) {
            $max = (int)preg_replace('/K$/i', '000', $def['max']);
            if ($var['size'] > $max) {
                return $name.'は'.$def['max'].'Byte以下のファイルを入力してください。';
            }
        }
    } else {
        if (isset($def['max']) && !is_null($def['max']) && strlen($var) > $def['max']) {
            return $name.'は半角'.$def['max'].'（全角'.ceil($def['max'] / 2).'）文字以上を入力してください。';
        }
    }

    // regexp
    if ($type != VAR_TYPE_FILE && isset($def['regexp']) && $def['regexp'] != null && strlen($var) > 0 && preg_match($def['regexp'], $var) == 0) {
        return $name.'を正しく入力してください。';
    }

    // other
    // ファイルタイプでファイルがアップロードされている時
    if ($type == VAR_TYPE_FILE && $var['error'] != UPLOAD_ERR_NO_FILE) {

        // エラーコードの検査
        switch ($var['error']) {
            case UPLOAD_ERR_INI_SIZE:
                return 'アップロードされたファイルは、php.ini の upload_max_filesize ディレクティブの値を超えています。';
                break;
            case UPLOAD_ERR_FORM_SIZE:
                return 'アップロードされたファイルは、HTML フォームで指定された MAX_FILE_SIZE を超えています。';
                break;
            case UPLOAD_ERR_PARTIAL:
                return 'アップロードされたファイルは一部のみしかアップロードされていません。';
                break;
            case UPLOAD_ERR_NO_TMP_DIR:
                return 'テンポラリフォルダがありません。';
                break;
            case UPLOAD_ERR_CANT_WRITE:
                return 'ディスクへの書き込みに失敗しました。';
                break;
        }
    }

    return false;
}

/**
 *  スカラーを配列にする
 *
 *  @param $var   配列にしたい値
 *  @return array
 */
function toArray($var)
{
    if ($var) {
        if (!is_array($var)) {
            $var = array($var);
        }
    }
    return $var;
}
