<?php

/**************************************************************
 * CGI's  MailForm ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

define('DEFAULT_CHAR_SET', 'UTf-8');
define('SAMPLE', false);

/**
*
* 共通処理
*
*/
function commonProc()
{
    // エラー制御
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);
    // 文字コード関連
    ini_set('mbstring.detect_order', 'UTF-8,EUC-JP,SJIS,JIS,ASCII');
    ini_set('mbstring.http_input', 'pass');
    ini_set('mbstring.http_output', 'pass');
    ini_set('mbstring.internal_encoding', strtolower(DEFAULT_CHAR_SET));
    ini_set('mbstring.substitute_character', 'none');
    ini_set('mbstring.default_charset', 'pass');
    // セッションスタート
    session_cache_limiter('private, must-revalidate');
    session_start();

    return null;
}

/**
*
* コンフィグ読込み
*
*/
function LoadConf($file, $md = 0)
{
    $conf_array = file($file);
    foreach ($conf_array as $c) {
        if (preg_match('/^<\?php/', $c)) {
            continue;
        }
        if (preg_match('/^\?>/', $c)) {
            continue;
        }
        if (preg_match('/^[\r\n\t\s]/', $c)) {
            continue;
        }
        list($conf_name, $conf_value) = explode(',', $c, 2);
        $conf_value = trim($conf_value);
        $conf_value = str_replace('<br>', "\n", $conf_value);
        $conf[$conf_name] = $conf_value;
    }
    return $conf;
}

/**
*
* コンフィグ書き込み
*
*/
function confWrite($file, $forms)
{
    //書き込みデータ作成
    $data = '<?php'."\n";
    foreach ($forms as $key => $value) {
        if ($key == 'md' || $key == 'err') {
            continue;
        }
        // 改行を変換
        $value['value'] = rtrim($value['value']);
        $value['value'] = str_replace("\r\n", "\n", $value['value']);
        $value['value'] = str_replace("\r", "\n", $value['value']);
        $value['value'] = str_replace("\n", "<br>", $value['value']);
        $data .= $key.','.$value['value']."\n";
    }
    $data .= '?>'."\n";

    // サンプルは編集不可
    if (SAMPLE == true) {
        return true;
    }
    
    //書き込み
    if ($fp = @fopen($file, "w")) {
        flock($fp, LOCK_EX);
        fwrite($fp, $data);
        fclose($fp);
        return true;
    }
    return false;
}

// HTML出力用エスケープ
function showEscap($var)
{
    if ($var != '') {
        if (!is_array($var)) {
            // エスケープ
            $var = htmlspecialchars($var);
        } else {
            foreach ($var as $key => $value) {
                $var[$key] = showEscap($value);
            }
        }
    }
    return $var;
}

function htmlHeader($title, $style = '', $js = '')
{
    $html = '<html>'."\n";
    $html .= '<head>'."\n";
    $html .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $html .= '<title>'.$title.'</title>'."\n";
    $html .= '<style type="text/css">'."\n";
    $html .= '<!--'."\n";
    $html .= $style;
    $html .= '-->'."\n";
    $html .= '</style>'."\n";
    if ($js) {
        $html .= $js."\n";
    }
    $html .= '</head>'."\n";
    $html .= '<body>'."\n";
    return $html;
}

function htmlFooter()
{
    $html = '</body>'."\n";
    $html .= '</html>'."\n";
    return $html;
}
