<?php

/**************************************************************
 * CGI's  MailForm ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

// 定数定義
define('CONF_FILE', 'conf/conf.php');

// 共通変数/関数読込み
include_once __DIR__ . '/inc.php';
include_once __DIR__ . '/forms.php';

// フォーム定義
$formMail = array(
    'md' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '操作モード',
        'required' => false,
    ),
    'pv' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'プレビュー',
        'required' => false,
    ),
    'name' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お名前',
    ),
    'mail' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メールアドレス',
        'regexp' => PTN_MAIL,
    ),
    'subject' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '件名',
    ),
    'body' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '本文',
    ),
);

// 共通処理
commonProc();

// フォーム値セット
$forms = importForms($formMail);

// 設定読込み
$confs = LoadConf(CONF_FILE);

// フォーム定義に必須項目情報付与
$forms = needForm($forms, $confs);


// 初期
if (!$forms['md']['value']) {
    $contents = defaultAction($forms, $confs);
}
// 確認
elseif ($forms['md']['value'] == 'confirm') {
    $contents = confirmAction($forms, $confs);
}
// 送信
elseif ($forms['md']['value'] == 'send') {
    $contents = sendAction($forms, $confs);
}

// 画面表示
$html = htmlHeader(showEscap($confs['title']), cssMail($confs));
$html .= '<div class="contents">'."\n";
$html .= '<h1>'.showEscap($confs['title']).'</h1>'."\n";
if ($confs['home']) {
    $html .= '<p class="right"><a href="'.showEscap($confs['home']).'">HOME</a></p>'."\n";
}
$html .= '<br>'."\n";
$html .= $contents;
$html .= '<br>'."\n";
$html .= '<p class="center"><a href="http://www.cgis.biz/">CGI\'s</a></p>'."\n";
$html .= '</div>'."\n";
$html .= htmlFooter();

echo $html;

exit;

// ================================================================================

/**
*
* 初期
*
*/
function defaultAction($forms, $confs)
{

    // 必須項目表示
    $need = array(false => '',true => '<span class="attention">※</span>');

    // プレビューへの配慮
    $btn = 'submit';
    if ($forms['pv']['value'] == 1) {
        $btn = 'button';
    }

    $html = '<div class="message">'."\n";
    $html .= nl2br(showEscap($confs['comment_input']))."\n";
    $html .= '</div>'."\n";
    $html .= ''."\n";
    $html .= '<form method="post" action="mail.php">'."\n";
    $html .= '<div class="mail_t">'."\n";
    if (SAMPLE == true) {
        $html .= '<p class="attention">サンプルにつきメール送信はされません。</p>'."\n";
    }
    $html .= '<p><span class="attention">※</span>は入力必須となります。</p>'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$need[($confs['need_name'])].showEscap($forms['name']['name']).'</th>'."\n";
    $html .= '<td><input type="text" name="name" value=""></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$need[($confs['need_mail'])].showEscap($forms['mail']['name']).'</th>'."\n";
    $html .= '<td><input type="text" name="mail" value="" size="50" class="imeoff"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$need[($confs['need_subject'])].showEscap($forms['subject']['name']).'</th>'."\n";
    $html .= '<td><input type="text" name="subject" value="" size="50"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$need[($confs['need_body'])].showEscap($forms['body']['name']).'</th>'."\n";
    $html .= '<td><textarea name="body" cols="40" rows="7"></textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<p class="center"><input type="'.$btn.'" value="確認" class="btn_l"></p>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="confirm">'."\n";
    $html .= '</form>'."\n";
    return $html;
}

/**
*
* 確認
*
*/
function confirmAction($forms, $confs)
{

    // フォーム値チェック
    $errors = validate($forms);
    if ($errors) {
        return errorContentsMail($errors);
    }

    $html = '<div class="message">'."\n";
    $html .= nl2br(showEscap($confs['comment_confirm']))."\n";
    $html .= '</div>'."\n";
    $html .= '<br>'."\n";
    $html .= '<form method="post" action="mail.php">'."\n";
    $html .= '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.showEscap($forms['name']['name']).'</th>'."\n";
    $html .= '<td>'.showEscap($forms['name']['value']).'</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.showEscap($forms['mail']['name']).'</th>'."\n";
    $html .= '<td>'.showEscap($forms['mail']['value']).'</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.showEscap($forms['subject']['name']).'</th>'."\n";
    $html .= '<td>'.showEscap($forms['subject']['value']).'</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.showEscap($forms['body']['name']).'</th>'."\n";
    $html .= '<td>'.nl2br(showEscap($forms['body']['value'])).'</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<p class="center"><input type="submit" value="送信" class="btn_l"></p>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="send">'."\n";
    foreach ($forms as $key => $value) {
        if ($key == 'md') {
            continue;
        }
        if ($key == 'pv') {
            continue;
        }
        $html .= '<input type="hidden" name="'.$key.'" value="'.showEscap($value['value']).'">'."\n";
    }
    $html .= '</form>'."\n";
    return $html;
}

/**
*
* 送信
*
*/
function sendAction($forms, $confs)
{
    // フォーム値チェック
    $errors = validate($forms);
    if ($errors) {
        return errorContentsMail($errors);
    }

    $body = 'お名前：'.$forms['name']['value']."\n";
    $body .= 'メールアドレス：'.$forms['mail']['value']."\n";
    $body .= '本文：'."\n";
    $body .= $forms['body']['value']."\n";
    $body2 = '-------------------------------------------------------------'."\n";
    $body2 .= '送信日時：'.date("Y/m/d H:i:s")."\n";
    $body2 .= '送信時IP：'.$_SERVER['REMOTE_ADDR']."\n";

    // メール送信
    if (mailSend($confs['admin'], $forms['subject']['value'], $body.$body2, $forms['mail']['value'], $confs['bcc'], null, $confs['j_from'])) {
        if ($confs['user_send'] == 1) {
            mailSend($forms['mail']['value'], $forms['subject']['value'].'[控え]', $body, $confs['admin'], null, null, $confs['j_from']);
        }
    } else {
        return errorContentsMail(array('メール送信に失敗しました。'));
    }

    $html = '<br>'."\n";
    $html .= '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th><div class="center">送信完了</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td>'."\n";
    $html .= nl2br(showEscap($confs['comment_send'])).'<br>'."\n";
    if ($confs['home']) {
        $html .= '<hr size="1">'."\n";
        $html .= '<a href="'.showEscap($confs['home']).'">HOMEへ戻る</a>'."\n";
    }

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    return $html;
}

/**
*
* エラー表示
*
*/
function errorContentsMail($errors)
{
    $html = '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td><span class="attention">Error</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td>'."\n";
    foreach ($errors as $error) {
        $html .= $error.'<br>'."\n";
    }
    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<br>'."\n";
    $html .= '<p class="center"><input type="button" value="&lt;&lt; 戻る" class="btn_l" onclick="javascript:history.back();"></p>'."\n";
    $html .= '</div>'."\n";
    return $html;
}

/**
*
* フォーム定義に必須項目情報追加
*
*/
function needForm($forms, $confs)
{
    if ($confs['need_name'] == 1) {
        $forms['name']['required'] = true;
    }
    if ($confs['need_mail'] == 1) {
        $forms['mail']['required'] = true;
    }
    if ($confs['need_subject'] == 1) {
        $forms['subject']['required'] = true;
    }
    if ($confs['need_body'] == 1) {
        $forms['body']['required'] = true;
    }
    return $forms;
}

function mailSend($to, $subject, $body, $from, $bcc = '', $ml_option = 0, $j_from = '')
{
    if ($ml_option) {
        $ml_option = "-f ".$from;
    }
    // header 作成
    if ($j_from) {
        $j_from = mb_convert_encoding($j_from, "JIS", "auto");
        $j_from = mb_encode_mimeheader($j_from);
        $from = $j_from.' <'.$from.'>';
    }
    $head = "From: ".$from."\n";
    if ($bcc) {
        $head .= "Bcc: ".$bcc."\n";
    }
    $head .= "Reply-To: ".$from."\n";
    $head .= "X-Mailer: PHP/".phpversion()."\n";
    $head .= "MIME-Version: 1.0\n";
    $head .= "Content-Type: text/plain; charset=ISO-2022-JP\n";
    $head .= "Content-Transfer-Encoding: 7bit";

    if ($subject) {
        $subject = "=?iso-2022-jp?B?".base64_encode(mb_convert_encoding($subject, "JIS", "auto"))."?=";
    }

    $body = preg_replace("/\r\n/", "\n", $body);
    $body = preg_replace("/\r/", "\n", $body);
    $body = mb_convert_encoding($body, "JIS", "auto");

    if (SAMPLE == true) {
        return true;
    }

    if ($ml_option) {
        $re = @mail($to, $subject, $body, $head, $ml_option);
    } else {
        $re = @mail($to, $subject, $body, $head);
    }
    return $re;
}

/**
*
* CSS
*
*/
function cssMail($confs)
{

    // 位置
    if ($confs['place'] == 1) {
        $body = 'center';
        $contents = '0px auto';
    } else {
        $body = 'left';
        $contents = '';
    }

    // エスケープ
    $confs = showEscap($confs);

    $css = <<<CSS
body {
    font-size: {$confs['font_size']}px;
    color: #{$confs['font_color']};
    text-align: {$body};
    background-color: #{$confs['bgcolor_body']};
}
.contents {
    margin: {$contents};
    text-align: left;
    width: {$confs['width']}px;
}
.contents h1 {
    text-align: center;
    font-size: {$confs['font_size_title']}px;
    margin-top: 20px;
}
.contents table {
    font-size: {$confs['font_size']}px;
    border-collapse: collapse;
}
.contents textarea {
    font-size: {$confs['font_size']}px;
    width: 350px;
}
form {
    margin: 0px;
}
.btn_l {
    width: 120px;
}
.mail_t {
    width: 100%;
}
.mail_t table {
	width: 100%;
}
.mail_t th {
    width: 30%;
	font-weight: normal;
	background-color: #{$confs['bgcolor_th']};
	padding: 4px;
	border: solid 1px #{$confs['border_form']};
	text-align: right;
}
.mail_t td {
    width: 70%;
    background-color: #{$confs['bgcolor_td']};
	padding: 4px;
	border: solid 1px #{$confs['border_form']};
}
.right {
    text-align: right;
}
.center {
    text-align: center;
}
.attention {
    color: #f33;
}
.error {
    color: #f33;
}
.imeoff {
    ime-mode: disabled;
}

CSS;
    return $css;
}
