<?php

/**************************************************************
 * CGI's  ShopMail ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

// 定数定義
define('CONF_FILE', __DIR__ . '/conf/conf.php');
define('TITLE', 'ShopMail管理画面');

// 共通変数/関数読込み
include_once __DIR__ . '/inc.php';
include_once __DIR__ . '/forms.php';

// フォーム定義
$formAdmin = array(
    'md' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '操作モード',
        'required' => false,
    ),
    'err' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'エラーフラグ',
        'required' => false,
    ),
    'pass' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者パスワード',
        'required' => true,
        'min' => 4,
        'max' => 12,
        'regexp' => PTN_PASS,
    ),
    'title' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メールフォームタイトル',
        'required' => false,
    ),
    'admin' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者メールアドレス',
        'required' => true,
        'regexp' => PTN_MAIL,
    ),
    'bcc' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'BCCメールアドレス',
        'required' => false,
        'regexp' => PTN_MAIL,
    ),
    'user_send' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'ユーザーへ送信',
        'required' => false,
    ),
    'j_from' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者メールアドレス（名前）',
        'required' => false,
    ),
    'home' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'HOME',
        'required' => false,
        'regexp' => PTN_URL,
    ),
    'subject' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メール件名',
        'required' => false,
    ),
    'comment_input' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '入力画面のコメント',
        'required' => false,
    ),
    'comment_confirm' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '確認画面のコメント',
        'required' => false,
    ),
    'comment_send' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '送信完了画面のコメント',
        'required' => false,
    ),
    'comment_mail' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メール内のコメント',
        'required' => false,
    ),
    'sig' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メール内の署名',
        'required' => false,
    ),
    'send_type' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '配送方法',
        'required' => false,
    ),
    'send_time' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '配送時間',
        'required' => false,
    ),
    'send_date_start' => array(
        'type' => VAR_TYPE_INT,
        'name' => '配送日(最小)',
        'required' => false,
    ),
    'send_date_end' => array(
        'type' => VAR_TYPE_INT,
        'name' => '配送日(最大)',
        'required' => false,
    ),
    'pay_type' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '支払方法',
        'required' => false,
    ),
    'order_form' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'ご注文入力項目数',
        'required' => false,
    ),
    'item_caption' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご注文入力項目の名称',
        'required' => false,
    ),
    'optional_name' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '任意項目(項目名)',
        'required' => false,
    ),
    'optional_type' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '任意項目(項目タイプ)',
        'required' => false,
    ),
    'optional_value' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '任意項目(項目選択肢)',
        'required' => false,
    ),
    'show_name' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(名前)',
        'required' => false,
    ),
    'show_name_kana' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(名前フリガナ)',
        'required' => false,
    ),
    'show_mail' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(メールアドレス)',
        'required' => false,
    ),
    'show_postal' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(郵便番号)',
        'required' => false,
    ),
    'show_address' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(住所)',
        'required' => false,
    ),
    'show_tel' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(電話番号)',
        'required' => false,
    ),
    'show_send_type' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(配送方法)',
        'required' => false,
    ),
    'show_send_date' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(配送日)',
        'required' => false,
    ),
    'show_send_time' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(配送時間)',
        'required' => false,
    ),
    'show_pay_type' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(支払方法)',
        'required' => false,
    ),
    'show_comment' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(通信欄)',
        'required' => false,
    ),
    'show_item' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(ご注文入力)',
        'required' => false,
    ),
    'show_dist_name' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(届け先名前)',
        'required' => false,
    ),
    'show_dist_name_kana' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(届け先名前フリガナ)',
        'required' => false,
    ),
    'show_dist_postal' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(届け先郵便番号)',
        'required' => false,
    ),
    'show_dist_address' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(届け先ご住所)',
        'required' => false,
    ),
    'show_dist_tel' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(届け先電話番号)',
        'required' => false,
    ),
    'show_optional' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(任意項目)',
        'required' => false,
    ),
    'need_name' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(名前)',
        'required' => false,
    ),
    'need_name_kana' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(名前フリガナ)',
        'required' => false,
    ),
    'need_mail' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(メールアドレス)',
        'required' => false,
    ),
    'need_postal' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(郵便番号)',
        'required' => false,
    ),
    'need_address' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(住所)',
        'required' => false,
    ),
    'need_tel' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(電話番号)',
        'required' => false,
    ),
    'need_send_type' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(配送方法)',
        'required' => false,
    ),
    'need_send_date' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(配送日)',
        'required' => false,
    ),
    'need_send_time' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(配送時間)',
        'required' => false,
    ),
    'need_pay_type' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(支払方法)',
        'required' => false,
    ),
    'need_item' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(ご注文入力)',
        'required' => false,
    ),
    'need_comment' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(通信欄)',
        'required' => false,
    ),
    'need_dist_name' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(届け先名前)',
        'required' => false,
    ),
    'need_dist_name_kana' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(届け先名前フリガナ)',
        'required' => false,
    ),
    'need_dist_postal' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(届け先郵便番号)',
        'required' => false,
    ),
    'need_dist_address' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(届け先ご住所)',
        'required' => false,
    ),
    'need_dist_tel' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(届け先電話番号)',
        'required' => false,
    ),
    'need_optional' => array(
        'type' => VAR_TYPE_INT,
        'name' => '表示/非表示(任意項目)',
        'required' => false,
    ),
    'bgcolor_body' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '全体の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'font_color' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '全体のフォントカラー',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'font_size' => array(
        'type' => VAR_TYPE_INT,
        'name' => '全体のフォントサイズ',
        'required' => true,
    ),
    'font_size_title' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'タイトルのフォントサイズ',
        'required' => true,
    ),
    'place' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'フォームの表示位置',
        'required' => true,
    ),
    'width' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'フォームの幅',
        'required' => true,
    ),
    'border_form' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'フォームの枠線色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'bgcolor_th' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '項目の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'bgcolor_td' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '入力欄の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'cookie' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'Cookieの利用',
        'required' => false,
    ),
);

// 共通処理
commonProc();

// フォーム値セット
$forms = importForms($formAdmin);

// 設定読込み
$confs = LoadConf(CONF_FILE);

$JS = '';

// 初期
if (!$forms['md']['value']) {
    $contents = loginAction($forms['err']['value']);
}
// ログイン実行
elseif ($forms['md']['value'] == 'loginExec') {
    $contents = loginExecAction($forms, $confs);
}
// 編集
elseif ($forms['md']['value'] == 'edit') {
    loginCheck($confs);
    $JS = jsAdmin();
    $contents = editAction($forms, $confs);
}
// 編集実行
elseif ($forms['md']['value'] == 'editExec') {
    loginCheck($confs);
    $contents = editExecAction($forms, $confs);
}
// ログアウト
elseif ($forms['md']['value'] == 'logout') {
    $contents = logoutAction($forms);
}

// 画面表示
$html = htmlHeader(TITLE, cssAdmin(), $JS);
$html .= '<div class="contents">'."\n";
$html .= '<h1>'.TITLE.'</h1>'."\n";
$html .= '<p class="right"><a href="mail.php">メールフォーム</a> | <a href="admin.php?md=logout">ログアウト</a></p>'."\n";
$html .= '<br>'."\n";
$html .= $contents;
$html .= '</div>'."\n";
$html .= htmlFooter();

echo $html;

exit;


// ================================================================================

/**
*
* 初期
*
*/
function loginAction($err = 0)
{
    $html = '<div class="center">'."\n";
    if ($err == 1) {
        $html .= '<p class="attention">パスワードが間違っています。</p>'."\n";
    } elseif ($err == 2) {
        $html .= '<p class="attention">パスワードが間違っているか、ログインセッションが無効となりました。</p>'."\n";
    }
    $html .= '<form method="post" action="admin.php">'."\n";
    $html .= '<input type="password" name="pass" value="">'."\n";
    $html .= '<input type="submit" value="ログイン">'."\n";
    $html .= '<input type="hidden" name="md" value="loginExec">'."\n";
    $html .= '</form>'."\n";
    $html .= '</div>'."\n";
    return $html;
}
/**
*
* ログイン
*
*/
function loginExecAction($forms, $confs)
{
    if ($forms['pass']['value'] === $confs['pass']) {
        $_SESSION['pass'] = $forms['pass']['value'];
        header('Location: admin.php?md=edit');
    } else {
        header('Location: admin.php?err=1');
    }
    return 'Error: Location Error';
}
/**
*
* ログインチェック
*
*/
function loginCheck($confs)
{
    if ($_SESSION['pass'] !== $confs['pass']) {
        header('Location: admin.php?err=2');
    }
}
/**
*
* 編集
*
*/
function editAction($forms, $confs)
{
    $chk = array('0' => '','1' => ' checked');

    $chk_keys = [
        'show_name',
        'show_name_kana',
        'show_postal',
        'show_address',
        'show_tel',
        'show_send_type',
        'show_send_date',
        'show_send_time',
        'show_pay_type',
        'show_comment',
        'show_item',
        'show_dist_name',
        'show_dist_name_kana',
        'show_dist_postal',
        'show_dist_address',
        'show_dist_tel',
        'show_optional',
        'need_name',
        'need_name_kana',
        'need_postal',
        'need_address',
        'need_tel',
        'need_send_type',
        'need_send_date',
        'need_send_time',
        'need_pay_type',
        'need_comment',
        'need_item',
        'need_dist_name',
        'need_dist_name_kana',
        'need_dist_postal',
        'need_dist_address',
        'need_dist_tel',
        'need_optional',
    ];

    foreach ($chk_keys as $chk_key) {
        if (isset($confs[$chk_key]) && $confs[$chk_key]) {
            $confs[$chk_key] = 1;
        } else {
            $confs[$chk_key] = 0;
        }
    }

    $html = '';
    if (SAMPLE == true) {
        $html .= '<p class="attention">サンプルにつき設定変更はできません。</p>'."\n";
    }
    $html .= '<p>※は入力必須となります。</p>'."\n";
    $html .= '<form method="post" action="admin.php" name="AdminForm">'."\n";
    $html .= '<div class="admin_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">基本的な項目</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['pass']['name'].'</th>'."\n";
    $html .= '<td><input type="password" name="pass" value="'.showEscap($confs['pass']).'"><br><span class="small">本画面アクセスパスワード。半角英数字4～12文字</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['title']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="title" value="'.showEscap($confs['title']).'"><br><span class="small">メールフォーム上部に表示されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['subject']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="subject" value="'.showEscap($confs['subject']).'"><br><span class="small">メールの件名。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['admin']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="admin" value="'.showEscap($confs['admin']).'" size="50" class="imeoff"><br><span class="small">このアドレスに投稿内容が送信されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['bcc']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="bcc" value="'.showEscap($confs['bcc']).'" size="50" class="imeoff"><br><span class="small">設定した場合、写しが送信されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['user_send']['name'].'</th>'."\n";
    $html .= '<td><input type="checkbox" name="user_send" value="1" id="user_send"'.$chk[($confs['user_send'])].'><label for="user_send"> 送信する</label><br><span class="small">チェックした場合、投稿者のメールアドレスへも送信します。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['j_from']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="j_from" value="'.showEscap($confs['j_from']).'"><br><span class="small">ユーザーへ送信をチェックしている場合、ユーザーへ送信するメールのFrom(管理者)アドレスの前に表示されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['home']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="home" value="'.showEscap($confs['home']).'" size="50" class="imeoff"><br><span class="small">メールフォーム右上に表示される「HOME」のリンクURL。未設定で非表示。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">文章の設定</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_input']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_input" cols="40" rows="3">'.showEscap($confs['comment_input']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_confirm']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_confirm" cols="40" rows="3">'.showEscap($confs['comment_confirm']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_send']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_send" cols="40" rows="3">'.showEscap($confs['comment_send']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_mail']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_mail" cols="40" rows="7">'.showEscap($confs['comment_mail']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['sig']['name'].'</th>'."\n";
    $html .= '<td><textarea name="sig" cols="40" rows="7">'.showEscap($confs['sig']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">選択肢の設定</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['send_type']['name'].'</th>'."\n";
    $html .= '<td><textarea name="send_type" cols="40" rows="3">'.showEscap($confs['send_type']).'</textarea><br><span class="small">カンマ区切り。改行は無視されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>配送日</th>'."\n";
    $html .= '<td><input type="text" name="send_date_start" value="'.showEscap($confs['send_date_start']).'" size="3" class="imeoff">日以降 - <input type="text" name="send_date_end" value="'.showEscap($confs['send_date_end']).'" size="3" class="imeoff">日まで<br><span class="small">半角数字。希望配送日を表示した場合、注文時の日付より上記期間の配送日を受け付けます。また、可能配送日としてその注釈を表示します。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['send_time']['name'].'</th>'."\n";
    $html .= '<td><textarea name="send_time" cols="40" rows="3">'.showEscap($confs['send_time']).'</textarea><br><span class="small">カンマ区切り。改行は無視されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['pay_type']['name'].'</th>'."\n";
    $html .= '<td><textarea name="pay_type" cols="40" rows="3">'.showEscap($confs['pay_type']).'</textarea><br><span class="small">カンマ区切り。改行は無視されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">項目の設定</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['order_form']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="order_form" value="'.showEscap($confs['order_form']).'" size="3" class="imeoff"><br><span class="small">半角数字。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['item_caption']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="item_caption" value="'.showEscap($confs['item_caption']).'"><br><span class="small">商品のキーとしてなにを入力するか？入力欄に項目名として表示。（例：商品名、商品番号、型番など）。</span></td>'."\n";
    $html .= '</tr>'."\n";

    $optional_array = array('radio' => 'ラジオボタン','checkbox' => 'チェックボックス','select' => 'ドロップダウン','text' => 'テキストボックス','textarea' => 'テキストエリア');

    $html .= '<tr>'."\n";
    $html .= '<th>任意項目</th>'."\n";
    $html .= '<td>'."\n";
    $html .= '項目名：<input type="text" name="optional_name" value="'.showEscap($confs['optional_name']).'"> / '."\n";
    $html .= '項目タイプ：'."\n";
    $html .= '<select name="optional_type">'."\n";
    $html .= '<option value=""></option>'."\n";
    foreach ($optional_array as $key => $val) {
        $slc = '';
        if ($key == $confs['optional_type']) {
            $slc = ' selected';
        }
        $html .= '<option value="'.$key.'"'.$slc.'>'.$val.'</option>'."\n";
    }
    $html .= '</select><br>'."\n";
    $html .= '<br>'."\n";
    $html .= '項目選択肢：<br><textarea name="optional_value" cols="50" rows="3">'.showEscap($confs['optional_value']).'</textarea><br>'."\n";
    $html .= '<span class="small">任意の項目を設定できます。<br>選択肢系の項目タイプを利用する場合は、項目選択肢もご入力ください。<br>選択肢系以外の項目タイプを設定した場合、項目選択肢を入力しても無視されます。<br>項目選択肢はカンマ区切り。<br>任意項目はお客様情報欄の最下段に表示されます。</span>'."\n";
    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>必須項目</th>'."\n";
    $html .= '<td>'."\n";
    $html .= '<input type="checkbox" name="need_name" value="1" id="need_name"'.$chk[($confs['need_name'])].'><label for="need_name"> 名前</label>'."\n";
    $html .= '<input type="checkbox" name="need_name_kana" value="1" id="need_name_kana"'.$chk[($confs['need_name_kana'])].'><label for="need_name_kana"> 名前（フリガナ）</label>'."\n";
    //	$html .= '<input type="checkbox" name="need_mail" value="1" id="need_mail"'.$chk[($confs['need_mail'])].'><label for="need_mail"> メールアドレス</label>'."\n";
    $html .= '<input type="checkbox" name="need_postal" value="1" id="need_postal"'.$chk[($confs['need_postal'])].'><label for="need_postal"> 郵便番号</label>'."\n";
    $html .= '<input type="checkbox" name="need_address" value="1" id="need_address"'.$chk[($confs['need_address'])].'><label for="need_address"> 住所</label>'."\n";
    $html .= '<input type="checkbox" name="need_tel" value="1" id="need_tel"'.$chk[($confs['need_tel'])].'><label for="need_tel"> 電話番号</label>'."\n";
    $html .= '<input type="checkbox" name="need_send_type" value="1" id="need_send_type"'.$chk[($confs['need_send_type'])].'><label for="need_send_type"> 配送方法</label>'."\n";
    $html .= '<input type="checkbox" name="need_send_date" value="1" id="need_send_date"'.$chk[($confs['need_send_date'])].'><label for="need_send_date"> 配送日</label>'."\n";
    $html .= '<input type="checkbox" name="need_send_time" value="1" id="need_send_time"'.$chk[($confs['need_send_time'])].'><label for="need_send_time"> 配送時間</label>'."\n";
    $html .= '<input type="checkbox" name="need_pay_type" value="1" id="need_pay_type"'.$chk[($confs['need_pay_type'])].'><label for="need_pay_type"> 支払方法</label>'."\n";
    $html .= '<input type="checkbox" name="need_comment" value="1" id="need_comment"'.$chk[($confs['need_comment'])].'><label for="need_comment"> 通信欄</label>'."\n";
    $html .= '<input type="checkbox" name="need_item" value="1" id="need_item"'.$chk[($confs['need_item'])].'><label for="need_item"> ご注文入力</label>'."\n";
    $html .= '<input type="checkbox" name="need_dist_name" value="1" id="need_dist_name"'.$chk[($confs['need_dist_name'])].'><label for="need_dist_name"> 届け先名前</label>'."\n";
    $html .= '<input type="checkbox" name="need_dist_name_kana" value="1" id="need_dist_name_kana"'.$chk[($confs['need_dist_name_kana'])].'><label for="need_dist_name_kana"> 届け先名前（フリガナ）</label>'."\n";
    $html .= '<input type="checkbox" name="need_dist_postal" value="1" id="need_dist_postal"'.$chk[($confs['need_dist_postal'])].'><label for="need_dist_postal"> 届け先郵便番号</label>'."\n";
    $html .= '<input type="checkbox" name="need_dist_address" value="1" id="need_dist_address"'.$chk[($confs['need_dist_address'])].'><label for="need_dist_address"> 届け先ご住所</label>'."\n";
    $html .= '<input type="checkbox" name="need_dist_tel" value="1" id="need_dist_tel"'.$chk[($confs['need_dist_tel'])].'><label for="need_dist_tel"> 届け先電話番号</label>'."\n";
    $html .= '<input type="checkbox" name="need_optional" value="1" id="need_optional"'.$chk[($confs['need_optional'])].'><label for="need_optional"> 任意項目</label>'."\n";
    $html .= '<br><span class="small">チェックで必須項目となります。メールアドレスは常に必須。</span><input type="hidden" name="need_mail" value="1"></td>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>表示/非表示</th>'."\n";
    $html .= '<td>'."\n";
    $html .= '<input type="checkbox" name="show_name" value="1" id="show_name"'.$chk[($confs['show_name'])].'><label for="show_name"> 名前</label>'."\n";
    $html .= '<input type="checkbox" name="show_name_kana" value="1" id="show_name_kana"'.$chk[($confs['show_name_kana'])].'><label for="show_name_kana"> 名前（フリガナ）</label>'."\n";
    //	$html .= '<input type="checkbox" name="show_mail" value="1" id="show_mail"'.$chk[($confs['show_mail'])].'><label for="show_mail"> メールアドレス</label>'."\n";
    $html .= '<input type="checkbox" name="show_postal" value="1" id="show_postal"'.$chk[($confs['show_postal'])].'><label for="show_postal"> 郵便番号</label>'."\n";
    $html .= '<input type="checkbox" name="show_address" value="1" id="show_address"'.$chk[($confs['show_address'])].'><label for="show_address"> 住所</label>'."\n";
    $html .= '<input type="checkbox" name="show_tel" value="1" id="show_tel"'.$chk[($confs['show_tel'])].'><label for="show_tel"> 電話番号</label>'."\n";
    $html .= '<input type="checkbox" name="show_send_type" value="1" id="show_send_type"'.$chk[($confs['show_send_type'])].'><label for="show_send_type"> 配送方法</label>'."\n";
    $html .= '<input type="checkbox" name="show_send_date" value="1" id="show_send_date"'.$chk[($confs['show_send_date'])].'><label for="show_send_date"> 配送日</label>'."\n";
    $html .= '<input type="checkbox" name="show_send_time" value="1" id="show_send_time"'.$chk[($confs['show_send_time'])].'><label for="show_send_time"> 配送時間</label>'."\n";
    $html .= '<input type="checkbox" name="show_pay_type" value="1" id="show_pay_type"'.$chk[($confs['show_pay_type'])].'><label for="show_pay_type"> 支払方法</label>'."\n";
    $html .= '<input type="checkbox" name="show_comment" value="1" id="show_comment"'.$chk[($confs['show_comment'])].'><label for="show_comment"> 通信欄</label>'."\n";
    $html .= '<input type="checkbox" name="show_item" value="1" id="show_item"'.$chk[($confs['show_item'])].'><label for="show_item"> ご注文入力</label>'."\n";
    $html .= '<input type="checkbox" name="show_dist_name" value="1" id="show_dist_name"'.$chk[($confs['show_dist_name'])].'><label for="show_dist_name"> 届け先名前</label>'."\n";
    $html .= '<input type="checkbox" name="show_dist_name_kana" value="1" id="show_dist_name_kana"'.$chk[($confs['show_dist_name_kana'])].'><label for="show_dist_name_kana"> 届け先名前（フリガナ）</label>'."\n";
    $html .= '<input type="checkbox" name="show_dist_postal" value="1" id="show_dist_postal"'.$chk[($confs['show_dist_postal'])].'><label for="show_dist_postal"> 届け先郵便番号</label>'."\n";
    $html .= '<input type="checkbox" name="show_dist_address" value="1" id="show_dist_address"'.$chk[($confs['show_dist_address'])].'><label for="show_dist_address"> 届け先ご住所</label>'."\n";
    $html .= '<input type="checkbox" name="show_dist_tel" value="1" id="show_dist_tel"'.$chk[($confs['show_dist_tel'])].'><label for="show_dist_tel"> 届け先電話番号</label>'."\n";
    $html .= '<input type="checkbox" name="show_optional" value="1" id="show_optional"'.$chk[($confs['show_optional'])].'><label for="show_optional"> 任意項目</label>'."\n";
    $html .= '<br><span class="small">チェックで表示、未チェックで非表示となります。メールアドレスは常に表示。<br>※前段で必須とした項目は必ずチェックしてください。</span><input type="hidden" name="show_mail" value="1"></td>'."\n";
    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">デザインの設定</div></th>'."\n";
    $html .= '</tr>'."\n";

    if ($confs['place'] == 1) {
        $chk0 = '';
        $chk1 = ' checked';
    } else {
        $chk0 = ' checked';
        $chk1 = '';
    }

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_body']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_body" value="'.showEscap($confs['bgcolor_body']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_body" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_body_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_body\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_color']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="font_color" value="'.showEscap($confs['font_color']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_font_color" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="font_color_btn" value="選択" onmousedown="ColorPickUp(\'font_color\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_size']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="font_size" value="'.showEscap($confs['font_size']).'" size="3" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_size_title']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="font_size_title" value="'.showEscap($confs['font_size_title']).'" size="3" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['place']['name'].'</th>'."\n";
    $html .= '<td><input type="radio" name="place" value="0"'.$chk0.' id="chk0"><label for="chk0"> LEFT</label> <input type="radio" name="place" value="1"'.$chk1.' id="chk1"><label for="chk1"> CENTER</label><br><span class="small">「CENTER」を選択で中央に配置となります</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['width']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="width" value="'.showEscap($confs['width']).'" size="5" size="5" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['border_form']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="border_form" value="'.showEscap($confs['border_form']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_border_form" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="border_form_btn" value="選択" onmousedown="ColorPickUp(\'border_form\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_th']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_th" value="'.showEscap($confs['bgcolor_th']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_th" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_th_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_th\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_td']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_td" value="'.showEscap($confs['bgcolor_td']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_td" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_td_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_td\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">その他の設定</div></th>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['cookie']['name'].'</th>'."\n";
    $html .= '<td><input type="checkbox" name="cookie" value="1" id="cookie"'.$chk[($confs['cookie'])].'><label for="cookie"> 利用する</label><br><span class="small">チェックした場合、次回ユーザー訪問時の入力補助が行われます。有効期限は90日です。</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '</table>'."\n";
    $html .= '<br>'."\n";
    $html .= '<p class="center"><input type="submit" name="submit" value="設定する" class="btn_l"></p>'."\n";
    $html .= '<br>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="editExec">'."\n";
    $html .= '</form>'."\n";

    return $html;
}

/**
*
* 編集実行
*
*/
function editExecAction($forms, $confs)
{
    // フォーム値チェック
    $errors = validate($forms);
    if ($errors) {
        return errorContentsAdmin($errors);
    }

    // 必須項目と表示/非表示の矛盾をチェック
    $errors = needValueCheck($forms);
    if ($errors) {
        return errorContentsAdmin($errors);
    }

    // 設定ファイル書き込み
    if (!confWrite(CONF_FILE, $forms)) {
        return errorContentsAdmin(array('設定ファイルの編集に失敗しました。'.CONF_FILE.'のパーミッションをご確認ください。'));
    } else {
        // セッションパスワード上書き
        $_SESSION['pass'] = $forms['pass']['value'];
        // 編集に戻す
        header('Location: admin.php?md=edit');
        return 'Error: Location Error';
    }
}
/**
*
* ログアウト
*
*/
function logoutAction()
{
    // パスワード消去
    $_SESSION['pass'] = '';
    // ログイン画面へ戻す
    header('Location: admin.php');
    return 'Error: Location Error';
}



// =====================================================================================================================================================

/**
*
* 必須項目と表示/非表示の矛盾をチェック
*
*/
function needValueCheck($forms)
{
    $errors = '';
    $chk_key = array(
'name' => '名前',
'name_kana' => '名前（フリガナ）',
'mail' => 'メールアドレス',
'postal' => '郵便番号',
'address' => '住所',
'tel' => '電話番号',
'send_type' => '配送方法',
'send_date' => '配送日',
'send_time' => '配送時間',
'pay_type' => '支払方法',
'item' => 'ご注文入力',
'comment' => '通信欄',
'dist_name' => '届け先名前',
'dist_name_kana' => '届け先名前（フリガナ）',
'dist_postal' => '届け先郵便番号',
'dist_address' => '届け先住所',
'dist_tel' => '届け先電話番号',
'optional' => '任意項目',
);
    foreach ($chk_key as $key => $val) {
        $need_key = 'need_'.$key;
        $show_key = 'show_'.$key;
        if ($forms[$need_key]['value'] && !$forms[$show_key]['value']) {
            $errors[] = '必須項目と表示/非表示の設定に矛盾があります。[ '.$val.' ]';
        }
    }
    return $errors;
}





/**
*
* エラー表示
*
*/
function errorContentsAdmin($errors)
{
    $html = '<div class="error">'."\n";
    $html .= '<p>Error</p>'."\n";
    foreach ($errors as $error) {
        $html .= $error.'<br>'."\n";
    }
    $html .= '<br>'."\n";
    $html .= '<input type="button" value="戻る" class="btn_l" onclick="javascript:history.back();">'."\n";
    $html .= '</div>'."\n";
    return $html;
}

/**
*
* CSS
*
*/
function cssAdmin()
{
    $css = <<<CSS
body {
    font-size: 12px;
    color: #666666;
    text-align: center;
}
.contents {
    margin: 0px auto;
    text-align: left;
    width: 600px;
}
.contents h1 {
    text-align: center;
    font-size: 12px;
}
.contents table {
    font-size: 12px;
    border-collapse: collapse;
}
.contents textarea {
    font-size: 12px;
    width: 400px;
}
form {
    margin: 0px;
}
.small {
    font-size: 10px;
    color: #83adaf;
}
.btn_l {
    width: 120px;
}
.admin_t {
    width: 100%;
}
.admin_t table {
	width: 100%;
}
.admin_t th {
    width: 30%;
	font-weight: normal;
	background-color: #eef;
	padding: 4px;
	border: solid 1px #ccc;
	text-align: right;
}
.admin_t td {
    width: 70%;
	padding: 4px;
	border: solid 1px #ccc;
}
.border0 table {
    width: auto;
}
.border0 td {
    border: none;
    width: auto;
}
.right {
    text-align: right;
}
.center {
    text-align: center;
}
.attention {
    color: #f33;
}
.error {
    color: #f33;
}
.imeoff {
    ime-mode: disabled;
}

CSS;
    return $css;
}

/**
*
* JavaScript
*
*/
function jsAdmin()
{
    $js = <<<JS
<script type="text/javascript" language="JavaScript">
<!--
function ColorSet() {
	window.document.getElementById("sample_bgcolor_body").style.backgroundColor  = "#"+window.document.AdminForm.bgcolor_body.value;
	window.document.getElementById("sample_font_color").style.backgroundColor    = "#"+window.document.AdminForm.font_color.value;
	window.document.getElementById("sample_border_form").style.backgroundColor = "#"+window.document.AdminForm.border_form.value;
	window.document.getElementById("sample_bgcolor_th").style.backgroundColor   = "#"+window.document.AdminForm.bgcolor_th.value;
	window.document.getElementById("sample_bgcolor_td").style.backgroundColor   = "#"+window.document.AdminForm.bgcolor_td.value;
}
function ColorPickUp(name) {
	if(navigator.appName == "Microsoft Internet Explorer") {
		window.document.AdminForm.bgcolor_body_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.font_color_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.border_form_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.bgcolor_th_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.bgcolor_td_btn.onmouseup = GetXY_IE;
	}
	else {
		window.document.AdminForm.bgcolor_body_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.font_color_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.border_form_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.bgcolor_th_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.bgcolor_td_btn.onmouseup = GetXY_NotIE;
	}
	
	function GetXY_IE() {
		OpenWin_x = event.screenX;
		OpenWin_y = event.screenY;
		window.open("color.php?name="+name,"cpWin","resizable=yes,width=255,height=170,location=no,menubar=no,status=no,toolbar=no,left="+OpenWin_x+",top="+OpenWin_y);
	}
	
	function GetXY_NotIE(evt){
		OpenWin_x = evt.screenX;
		OpenWin_y = evt.screenY;
		window.open("color.php?name="+name,"cpWin","resizable=yes,width=255,height=170,location=no,menubar=no,status=no,toolbar=no,left="+OpenWin_x+",top="+OpenWin_y);
	}
}
setTimeout("ColorSet()",500);
//-->
</script>

JS;
    return $js;
}
