<?php

/**************************************************************
 * CGI's  ShopMail ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

define('DEFAULT_CHAR_SET', 'UTF-8');
define('SAMPLE', false);

/**
*
* 共通処理
*
*/
function commonProc()
{
    // エラー制御
    error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);
    // 文字コード関連
    ini_set('mbstring.detect_order', 'UTF-8,EUC-JP,SJIS,JIS,ASCII');
    ini_set('mbstring.substitute_character', 'none');
    ini_set('mbstring.default_charset', 'pass');

    // セッションスタート
    session_cache_limiter('private, must-revalidate');
    session_start();

    return null;
}

/**
*
* コンフィグ書き込み
*
*/
function confWrite($file, $forms)
{

    //書き込みデータ作成
    $data = '<?php'."\n";
    foreach ($forms as $key => $value) {
        if ($key == 'md' || $key == 'err') {
            continue;
        }
        // 改行を変換
        $value['value'] = rtrim($value['value']);
        $value['value'] = str_replace("\r\n", "\n", $value['value']);
        $value['value'] = str_replace("\r", "\n", $value['value']);
        $value['value'] = str_replace("\n", "<br>", $value['value']);
        $data .= $key.','.$value['value']."\n";
    }
    $data .= '?>'."\n";

    // サンプルは編集不可
    if (SAMPLE == true) {
        return true;
    }

    //書き込み
    if ($fp = @fopen($file, "w")) {
        flock($fp, LOCK_EX);
        fwrite($fp, $data);
        fclose($fp);
        return true;
    }
    return false;
}

// HTML出力用エスケープ
function showEscap($var)
{
    if ($var != '') {
        if (!is_array($var)) {
            // エスケープ
            $var = htmlspecialchars($var);
        } else {
            foreach ($var as $key => $value) {
                $var[$key] = showEscap($value);
            }
        }
    }
    return $var;
}

function htmlHeader($title, $style = '', $js = '')
{
    $html = '<html>'."\n";
    $html .= '<head>'."\n";
    $html .= '<meta http-equiv="Content-Type" content="text/html; charset=EUC-JP">'."\n";
    $html .= '<title>'.$title.'</title>'."\n";
    $html .= '<style type="text/css">'."\n";
    $html .= '<!--'."\n";
    $html .= $style;
    $html .= '-->'."\n";
    $html .= '</style>'."\n";
    if ($js) {
        $html .= $js."\n";
    }
    $html .= '</head>'."\n";
    $html .= '<body>'."\n";
    return $html;
}

function htmlFooter()
{
    $html = '</body>'."\n";
    $html .= '</html>'."\n";
    return $html;
}

/**
*
* コンフィグ読込み
*
*/
function LoadConf($file, $md = 0)
{
    $conf_array = file($file);

    foreach ($conf_array as $c) {
        if (preg_match('/^<\?php/', $c)) {
            continue;
        }
        if (preg_match('/^\?>/', $c)) {
            continue;
        }
        if (preg_match('/^[\r\n\t\s]/', $c)) {
            continue;
        }
        list($conf_name, $conf_value) = explode(',', $c, 2);

        // 末尾改行除去
        $conf_value = trim($conf_value);
        // br戻し
        $conf_value = str_replace('<br>', "\n", $conf_value);

        $conf[$conf_name] = $conf_value;
    }
    return $conf;
}

/**
*
* Cookie セット
*
*/
function setCookies($forms)
{
    foreach ($forms as $key => $val) {
        $forms[$key]['value'] = str_replace(',', '&#44;', $val['value']);
    }
    $cookie  = $forms['name']['value'].',';
    $cookie .= $forms['name_kana']['value'].',';
    $cookie .= $forms['mail']['value'].',';
    $cookie .= $forms['postal']['value'].',';
    $cookie .= $forms['address']['value'].',';
    $cookie .= $forms['tel']['value'].',';
    $cookie .= $forms['dist_name']['value'].',';
    $cookie .= $forms['dist_name_kana']['value'].',';
    $cookie .= $forms['dist_postal']['value'].',';
    $cookie .= $forms['dist_address']['value'].',';
    $cookie .= $forms['dist_tel']['value'];
    setcookie('cgis_shop_mail', $cookie, (time() + 60 * 60 * 24 * 90));
}
/**
*
* Cookie 読込み
*
*/
function cookieRead()
{
    if ($_COOKIE['cgis_shop_mail']) {
        $array = explode(',', $_COOKIE['cgis_shop_mail']);
        foreach ($array as $key => $value) {
            $array[$key] = str_replace('&#44;', ',', $value);
        }
        $C['name']           = $array[0];
        $C['name_kana']      = $array[1];
        $C['mail']           = $array[2];
        $C['postal']         = $array[3];
        $C['address']        = $array[4];
        $C['tel']            = $array[5];
        $C['dist_name']      = $array[6];
        $C['dist_name_kana'] = $array[7];
        $C['dist_postal']    = $array[8];
        $C['dist_address']   = $array[9];
        $C['dist_tel']       = $array[10];
    }
    return $C;
}

/*
*
* 外部からの商品取得
*
*/
function getItem()
{
    $items = [];

    // 商品名
    if (isset($_GET['item_name']) && $_GET['item_name']) {
        if (!is_array($_GET['item_name'])) {
            $item_name_array[0] = $_GET['item_name'];
        } else {
            $item_name_array = $_GET['item_name'];
        }
        foreach ($item_name_array as $key => $value) {
            $items['item_name'][] = urldecode($value);
        }
    }
    if (isset($_POST['item_name']) && $_POST['item_name']) {
        if (!is_array($_POST['item_name'])) {
            $_POST['item_name'][0] = $_POST['item_name'];
        }
        foreach ($_POST['item_name'] as $key => $value) {
            $items[] = $value;
        }
    }
    // 商品数量
    if (isset($_REQUEST['item_count']) && $_REQUEST['item_count']) {
        if (!is_array($_REQUEST['item_count'])) {
            $item_count_array[0] = $_REQUEST['item_count'];
        } else {
            $item_count_array = $_REQUEST['item_count'];
        }
        foreach ($item_count_array as $key => $value) {
            $items['item_count'][] = (int)$value;
        }
    }
    return $items;
}
