<?php

/**************************************************************
 * CGI's  ShopMail ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

// 定数定義
define('CONF_FILE', __DIR__ . '/conf/conf.php');

// 共通変数/関数読込み
include_once __DIR__ . '/inc.php';
include_once __DIR__ . '/forms.php';

// フォーム定義
$formMail = array(
    'md' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '操作モード',
        'required' => false,
    ),
    'name' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お名前',
    ),
    'name_kana' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お名前(フリガナ)',
    ),
    'mail' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メールアドレス',
        'regexp' => PTN_MAIL,
    ),
    'postal' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '郵便番号',
        'regexp' => PTN_ZIP,
    ),
    'address' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご住所',
    ),
    'tel' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '電話番号',
        'regexp' => PTN_TEL,
    ),
    'send_type' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご希望配送方法',
    ),
    'send_date_y' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご希望配送日(年)',
    ),
    'send_date_m' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご希望配送日(月)',
    ),
    'send_date_d' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご希望配送日(日)',
    ),
    'send_time' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'ご希望配送時間',
    ),
    'pay_type' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お支払方法',
    ),
    'comment' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '通信欄',
    ),
    'optional' => array(
    ),
    'item_name' => array(
        'type' => array(VAR_TYPE_STRING),
        'required' => false,
    ),
    'item_count' => array(
        'type' => array(VAR_TYPE_INT),
        'name' => '商品情報',
        'min' => 1,
    ),
    'dist_name' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お届け先お名前',
    ),
    'dist_name_kana' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お届け先お名前(フリガナ)',
    ),
    'dist_postal' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お届け先郵便番号',
        'regexp' => PTN_ZIP,
    ),
    'dist_address' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お届け先ご住所',
    ),
    'dist_tel' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'お届け先電話番号',
        'regexp' => PTN_TEL,
    ),

);

// 共通処理
commonProc();

// 設定読込み
$confs = LoadConf(CONF_FILE);

// 設定値を元にフォーム定義修正
$forms = setForms($formMail, $confs);

// フォーム値セット
$forms = importForms($forms);

// 初期
if (!$forms['md']['value']) {
    $contents = defaultAction($forms, $confs);
}
// 確認
elseif ($forms['md']['value'] == 'confirm') {
    $contents = confirmAction($forms, $confs);
}
// 送信
elseif ($forms['md']['value'] == 'send') {
    $contents = sendAction($forms, $confs);
}

// 画面表示
$html = htmlHeader(showEscap($confs['title']), cssMail($confs));
$html .= '<div class="contents">'."\n";
$html .= '<h1>'.showEscap($confs['title']).'</h1>'."\n";
if ($confs['home']) {
    $html .= '<p class="right"><a href="'.showEscap($confs['home']).'">HOME</a></p>'."\n";
}
$html .= '<br>'."\n";
$html .= Progress($forms['md']['value'])."\n";
$html .= '<br>'."\n";
$html .= $contents;
$html .= '<br>'."\n";
$html .= '<p class="center"><a href="http://www.cgis.biz/">CGI\'s</a></p>'."\n";
$html .= '</div>'."\n";
$html .= htmlFooter();

echo $html;

exit;

// ================================================================================
/**
*
* 進行
*
*/
function Progress($md)
{
    $modes = array('input' => '入力','confirm' => '確認','send' => '完了');

    if ($md == '') {
        $md = 'input';
    }

    $progress = '';
    foreach ($modes as $key => $value) {
        if ($key == $md) {
            $progress .= '<span id="active">'.$value.'</span> &gt;&gt; '."\n";
        } else {
            $progress .= '<span>'.$value.'</span> &gt;&gt; '."\n";
        }
    }
    $html = '<div class="progress">'.substr_replace($progress, '', -10).'</div>'."\n";
    return $html;
}


/**
*
* 初期
*
*/
function defaultAction($forms, $confs)
{
    // Cokkie利用時
    if ($confs['cookie'] == 1) {
        $C = cookieRead();
    }

    // 外部からの商品GET/POST
    $items = getItem();

    // 必須項目表示
    $need = array(0 => '',1 => '<span class="attention">※</span>');
    $need_keys = [
        'need_name',
        'need_name_kana',
        'need_mail',
        'need_postal',
        'need_address',
        'need_tel',
        'need_send_type',
        'need_send_date',
        'need_send_time',
        'need_pay_type',
        'need_item',
        'need_comment',
        'need_dist_name',
        'need_dist_name_kana',
        'need_dist_postal',
        'need_dist_address',
        'need_dist_tel',
        'need_optional',
    ];

    foreach ($need_keys as $need_key) {
        if (isset($confs[$need_key]) && $confs[$need_key]) {
            $confs[$need_key] = 1;
        } else {
            $confs[$need_key] = 0;
        }
    }

    $html = '<div class="message">'."\n";
    $html .= nl2br(showEscap($confs['comment_input']))."\n";
    $html .= '</div>'."\n";
    $html .= ''."\n";
    $html .= '<form method="post" action="mail.php">'."\n";
    $html .= '<div class="mail_t">'."\n";
    if (SAMPLE == true) {
        $html .= '<p class="attention">サンプルにつきメール送信はされません。</p>'."\n";
    }
    $html .= '<p><span class="attention">※</span>は入力必須となります。</p>'."\n";
    $html .= '<table>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">お客様情報</div></th>'."\n";
    $html .= '</tr>'."\n";

    if ($confs['show_name'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_name'])].showEscap($forms['name']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="name" value="'.showEscap($C['name']).'"><br><span class="small">フルネーム。（例：山田一郎）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_name_kana'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_name_kana'])].showEscap($forms['name_kana']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="name_kana" value="'.showEscap($C['name_kana']).'"><br><span class="small">全角カタカナ。（例：ヤマダイチロウ）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_mail'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_mail'])].showEscap($forms['mail']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="mail" value="'.showEscap($C['mail']).'" size="50" class="imeoff"><br><span class="small">（例：ichiro@yamada.com）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_postal'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_postal'])].showEscap($forms['postal']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="postal" value="'.showEscap($C['postal']).'" size="10" class="imeoff"><br><span class="small">半角数字とハイフン。（例：100-0000）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_address'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_address'])].showEscap($forms['address']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="address" value="'.showEscap($C['address']).'" size="50"><br><span class="small">（例：東京都千代田区霞が関1丁目1-1）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_tel'])].showEscap($forms['tel']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="tel" value="'.showEscap($C['tel']).'" size="15" class="imeoff"><br><span class="small">半角数字とハイフン。（例：03-0000-0000）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_type'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_send_type'])].showEscap($forms['send_type']['name']).'</th>'."\n";
        $html .= '<td>'.SendType($confs['send_type']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_date'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_send_date'])].'ご希望配送日</th>'."\n";
        $html .= '<td>'.SendDate().enableDate($confs).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_time'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_send_time'])].showEscap($forms['send_time']['name']).'</th>'."\n";
        $html .= '<td>'.SendTime($confs).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_pay_type'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_pay_type'])].showEscap($forms['pay_type']['name']).'</th>'."\n";
        $html .= '<td>'.PayType($confs).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_comment'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_comment'])].showEscap($forms['comment']['name']).'</th>'."\n";
        $html .= '<td><textarea name="comment" cols="50" rows="5"></textarea></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_optional'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_optional'])].showEscap($forms['optional']['name']).'</th>'."\n";
        $html .= '<td>'.OptionalForm($confs, 'input').'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_item'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th colspan="2"><div class="center">ご注文入力</div></th>'."\n";
        $html .= '</tr>'."\n";
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_item'])].'ご注文</th>'."\n";
        $html .= '<td>'.OrderForm($confs, 'input', $forms, $items).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name'] == 1 || $confs['show_dist_name_kana'] == 1 || $confs['show_dist_postal'] == 1 || $confs['show_dist_address'] == 1 || $confs['show_dist_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th colspan="2"><div class="center">送付先情報</div></th>'."\n";
        $html .= '</tr>'."\n";
        $html .= '<tr>'."\n";
        $html .= '<td colspan="2"><span class="small">お届け先がお客様情報と異なる場合、以下を全てご記入ください。</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_dist_name'])].showEscap($forms['dist_name']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="dist_name" value="'.showEscap($C['dist_name']).'"><br><span class="small">フルネーム。（例：山田二郎）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name_kana'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_dist_name_kana'])].showEscap($forms['dist_name_kana']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="dist_name_kana" value="'.showEscap($C['dist_name_kana']).'"><br><span class="small">全角カタカナ。（例：ヤマダジロウ）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_postal'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_dist_postal'])].showEscap($forms['dist_postal']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="dist_postal" value="'.showEscap($C['dist_postal']).'" size="10" class="imeoff"><br><span class="small">半角数字とハイフン。（例：100-0000）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_address'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_dist_address'])].showEscap($forms['dist_address']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="dist_address" value="'.showEscap($C['dist_address']).'" size="50"><br><span class="small">（例：東京都千代田区霞が関1丁目1-1）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.$need[($confs['need_dist_tel'])].showEscap($forms['dist_tel']['name']).'</th>'."\n";
        $html .= '<td><input type="text" name="dist_tel" value="'.showEscap($C['dist_tel']).'" size="15" class="imeoff"><br><span class="small">半角数字とハイフン。（例：03-0000-0000）</span></td>'."\n";
        $html .= '</tr>'."\n";
    }

    $html .= '</table>'."\n";

    $html .= '<br>'."\n";

    $html .= '<p class="center"><input type="submit" value="確認" class="btn_l"></p>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="confirm">'."\n";
    $html .= '</form>'."\n";
    return $html;
}



/**
*
* 確認
*
*/
function confirmAction($forms, $confs)
{
    $errors = array();
    // フォーム値チェック
    $errors_validate = validate($forms);
    if (is_array($errors_validate) && count($errors_validate) > 0) {
        $errors = array_merge($errors, $errors_validate);
    }
    // フォーム値その他チェック
    $errors_other = checkOther($forms, $confs);
    if (is_array($errors_other) && count($errors_other) > 0) {
        $errors = array_merge($errors, $errors_other);
    }

    if (count($errors) > 0) {
        return errorContentsMail($errors);
    }

    $html = '<div class="message">'."\n";
    $html .= nl2br(showEscap($confs['comment_confirm']))."\n";
    $html .= '</div>'."\n";
    $html .= '<br>'."\n";
    $html .= '<form method="post" action="mail.php">'."\n";
    $html .= '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">お客様情報</div></th>'."\n";
    $html .= '</tr>'."\n";

    if ($confs['show_name'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['name']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['name']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_name_kana'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['name_kana']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['name_kana']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_mail'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['mail']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['mail']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_postal'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['postal']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['postal']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_address'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['address']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['address']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['tel']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['tel']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_type'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['send_type']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['send_type']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_date'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>ご希望配送日</th>'."\n";
        $html .= '<td>'.showEscap($forms['send_date_y']['value']).'年'.showEscap($forms['send_date_m']['value']).'月'.showEscap($forms['send_date_d']['value']).'日'.'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_send_time'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['send_time']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['send_time']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_pay_type'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['pay_type']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['pay_type']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_comment'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['comment']['name']).'</th>'."\n";
        $html .= '<td>'.nl2br(showEscap($forms['comment']['value'])).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_optional'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['optional']['name']).'</th>'."\n";
        $html .= '<td>'.nl2br(showEscap(OptionalForm($confs, 'confirm', $forms))).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_item'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th colspan="2"><div class="center">ご注文入力</div></th>'."\n";
        $html .= '</tr>'."\n";
        $html .= '<tr>'."\n";
        $html .= '<th>ご注文</th>'."\n";
        $html .= '<td>'.OrderForm($confs, 'confirm', $forms).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name'] == 1 || $confs['show_dist_name_kana'] == 1 || $confs['show_dist_postal'] == 1 || $confs['show_dist_address'] == 1 || $confs['show_dist_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th colspan="2"><div class="center">送付先情報</div></th>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['dist_name']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['dist_name']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_name_kana'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['dist_name_kana']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['dist_name_kana']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_postal'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['dist_postal']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['dist_postal']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_address'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['dist_address']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['dist_address']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    if ($confs['show_dist_tel'] == 1) {
        $html .= '<tr>'."\n";
        $html .= '<th>'.showEscap($forms['dist_tel']['name']).'</th>'."\n";
        $html .= '<td>'.showEscap($forms['dist_tel']['value']).'</td>'."\n";
        $html .= '</tr>'."\n";
    }

    $html .= '</table>'."\n";

    $html .= '<br>'."\n";

    $html .= '<p class="center"><input type="submit" value="完了" class="btn_l"></p>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="send">'."\n";
    foreach ($forms as $key => $value) {
        if ($key == 'md') {
            continue;
        }
        if (is_array($value['value'])) {
            foreach ($value['value'] as $k => $v) {
                if ($v != '') {
                    $html .= '<input type="hidden" name="'.$key.'['.$k.']" value="'.showEscap($v).'">'."\n";
                }
            }
        } else {
            $html .= '<input type="hidden" name="'.$key.'" value="'.showEscap($value['value']).'">'."\n";
        }
    }
    $html .= '</form>'."\n";

    return $html;
}

/**
*
* 送信
*
*/
function sendAction($forms, $confs)
{
    $errors = array();
    // フォーム値チェック
    $errors_validate = validate($forms);
    if (is_array($errors_validate) && count($errors_validate) > 0) {
        $errors = array_merge($errors, $errors_validate);
    }
    // フォーム値その他チェック
    $errors_other = checkOther($forms, $confs);
    if (is_array($errors_other) && count($errors_other) > 0) {
        $errors = array_merge($errors, $errors_other);
    }

    if (count($errors) > 0) {
        return errorContentsMail($errors);
    }

    $body = '';
    if ($confs['show_name']) {
        $body .= $forms['name']['value'].' 様'."\n";
    }

    $body .= '                                                                    '.date("Y年 m月 d日")."\n";
    $body .= ''."\n";
    $body .= $confs['comment_mail']."\n";
    $body .= ''."\n";

    if ($confs['show_item']) {
        $body .= '====================【ご注文内容】===================='."\n";
        $body .= OrderForm($confs, 'send', $forms);
        $body .= ''."\n";
    }

    $body .= '====================【お客様情報】===================='."\n";

    if ($confs['show_name']) {
        $body .= 'お名前： '.                     $forms['name']['value']."\n";
    }

    if ($confs['show_name_kana']) {
        $body .= 'お名前（フリガナ）： '.         $forms['name_kana']['value']."\n";
    }

    if ($confs['show_mail']) {
        $body .= 'メールアドレス： '.             $forms['mail']['value']."\n";
    }

    if ($confs['show_postal']) {
        $body .= '郵便番号： '.                   $forms['postal']['value']."\n";
    }

    if ($confs['show_address']) {
        $body .= 'ご住所： '.                     $forms['address']['value']."\n";
    }

    if ($confs['show_tel']) {
        $body .= '電話番号： '.                   $forms['tel']['value']."\n";
    }

    if ($confs['show_send_type']) {
        $body .= 'ご希望配送方法： '.             $forms['send_type']['value']."\n";
    }

    if ($confs['show_send_date']) {
        $body .= 'ご希望配送日： '.               $forms['send_date_y']['value'].'年 '.sprintf("%02d", $forms['send_date_m']['value']).'月 '.sprintf("%02d", $forms['send_date_d']['value']).'日'."\n";
    }

    if ($confs['show_send_time']) {
        $body .= 'ご希望配送時間： '.             $forms['send_time']['value']."\n";
    }

    if ($confs['show_pay_type']) {
        $body .= 'お支払方法： '.                 $forms['pay_type']['value']."\n";
    }

    if ($confs['show_comment']) {
        $body .= '通信欄： '.                     $forms['comment']['value']."\n";
    }

    if ($confs['show_optional']) {
        $body .= $confs['optional_name'].'： '.    OptionalForm($confs, 'send', $forms)."\n";
    }

    $body .= ''."\n";
    if ($confs['show_dist_name'] == 1 || $confs['show_dist_name_kana'] == 1 || $confs['show_dist_postal'] == 1 || $confs['show_dist_address'] == 1 || $confs['show_dist_tel'] == 1) {
        $body .= '====================【送付先情報】===================='."\n";
    }
    if ($forms['dist_name']['value'] == '' && !$forms['dist_name_kana']['value'] == '' && !$forms['dist_postal']['value'] == '' && !$forms['dist_address']['value'] == '' && !$forms['dist_tel']['value'] == '') {
        $body .= ''."\n";
        $body .= 'お客様情報に送付'."\n";
    } else {
        if ($confs['show_dist_name']) {
            $body .= 'お届け先お名前： '.             $forms['dist_name']['value']."\n";
        }

        if ($confs['show_dist_name_kana']) {
            $body .= 'お届け先お名前（フリガナ）： '. $forms['dist_name_kana']['value']."\n";
        }

        if ($confs['show_dist_postal']) {
            $body .= 'お届け先郵便番号： '.           $forms['dist_postal']['value']."\n";
        }

        if ($confs['show_dist_address']) {
            $body .= 'お届け先ご住所： '.             $forms['dist_address']['value']."\n";
        }

        if ($confs['show_dist_tel']) {
            $body .= 'お届け先電話番号： '.           $forms['dist_tel']['value']."\n";
        }
    }
    $body .= ''."\n";
    $body .= ''."\n";
    $body .= $confs['sig']."\n";

    $body2 = '------------------------------------------------------'."\n";
    $body2 .= '（管理者情報）この部分はお客様へは送信されていません。'."\n";
    $body2 .= '送信日時：'.date("Y/m/d H:i:s")."\n";
    $body2 .= '送信時IP：'.$_SERVER['REMOTE_ADDR']."\n";

    // メール送信
    if (mailSend($confs['admin'], $confs['subject'], $body.$body2, $forms['mail']['value'], $confs['bcc'], null, $confs['j_from'])) {
        if ($confs['user_send'] == 1) {
            mailSend($forms['mail']['value'], $confs['subject'].'[控え]', $body, $confs['admin'], null, null, $confs['j_from']);
        }
    } else {
        return errorContentsMail(array('メール送信に失敗しました。'));
    }

    if ($confs['cookie'] == 1) {
        setCookies($forms);
    }

    $html = '<br>'."\n";
    $html .= '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th><div class="center">送信完了</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td>'."\n";
    $html .= nl2br(showEscap($confs['comment_send'])).'<br>'."\n";
    if ($confs['home']) {
        $html .= '<hr size="1">'."\n";
        $html .= '<a href="'.showEscap($confs['home']).'">HOMEへ戻る</a>'."\n";
    }

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    return $html;
}


/**
*
* エラー表示
*
*/
function errorContentsMail($errors)
{
    $html = '<div class="mail_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td><span class="attention">Error</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td>'."\n";
    foreach ($errors as $error) {
        $html .= $error.'<br>'."\n";
    }
    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '<br>'."\n";
    $html .= '<p class="center"><input type="button" value="&lt;&lt; 戻る" class="btn_l" onclick="javascript:history.back();"></p>'."\n";
    $html .= '</div>'."\n";
    return $html;
}

/**
*
* 設定値を元にフォーム定義修正
*
*/
function setForms($forms, $confs)
{
    // ご注文入力項目の名称
    $forms['item_name']['name'] = $confs['item_caption'];
    // 任意項目
    $forms['optional']['type'] = VAR_TYPE_STRING;
    if ($confs['optional_type'] == 'checkbox') {
        $forms['optional']['type'] = array(VAR_TYPE_STRING);
    }
    $forms['optional']['name'] = $confs['optional_name'];

    // 必須項目
    foreach ($confs as $conf_key => $conf_value) {
        if (preg_match('/^need_/', $conf_key)) {

            // 値セット
            if ($conf_value == 1) {
                $required = true;
            } else {
                $required = false;
            }

            // 接頭部
            $key = str_replace('need_', '', $conf_key);

            // 特別
            if ($key == 'item') {
                $forms['item_count']['required'] = $required;
            } elseif ($key == 'send_date') {
                $forms['send_date_y']['required'] = $required;
                $forms['send_date_m']['required'] = $required;
                $forms['send_date_d']['required'] = $required;
            } else {
                $forms[$key]['required'] = $required;
            }
        }
    }
    return $forms;
}

/**
*
* 希望配送方法フォーム
*
*/
function SendType($send_type)
{
    $send_type_array = explode(',', $send_type);
    $send_type_array = showEscap($send_type_array);

    $html = '';
    if (count($send_type_array)) {
        $html .= '<select name="send_type">'."\n";
        $html .= '<option value=""></option>'."\n";
        foreach ($send_type_array as $val) {
            $html .= '<option value="'.$val.'">'.$val.'</option>'."\n";
        }
        $html .= '</select>'."\n";
    }
    return $html;
}
/**
*
* 希望配送日フォーム
*
*/
function SendDate()
{
    $html = '<select name="send_date_y">'."\n";
    $html .= '<option value=""></option>'."\n";
    $html .= '<option value="'.date("Y").'">'.date("Y").'</option>'."\n";
    $html .= '<option value="'.(date("Y") + 1).'">'.(date("Y") + 1).'</option>'."\n";
    $html .= '</select> 年'."\n";

    $html .= '<select name="send_date_m">'."\n";
    $html .= '<option value=""></option>'."\n";
    for ($i = 1; $i <= 12; $i++) {
        $html .= '<option value="'.$i.'">'.$i.'</option>'."\n";
    }
    $html .= '</select> 月'."\n";

    $html .= '<select name="send_date_d">'."\n";
    $html .= '<option value=""></option>'."\n";
    for ($i = 1; $i <= 31; $i++) {
        $html .= '<option value="'.$i.'">'.$i.'</option>'."\n";
    }
    $html .= '</select> 日'."\n";

    return $html;
}
/**
*
* 配送可能日テキスト
*
*/
function enableDate($confs)
{
    if ($confs['send_date_start'] || $confs['send_date_end']) {
        if ($confs['send_date_start']) {
            $start = (int)$confs['send_date_start'].'日以降';
        }
        if ($confs['send_date_end']) {
            $end = (int)$confs['send_date_end'].'日以内';
        }
        $send_date = '<br><span class="small">可能配送日：本日より'.$start.$end.'でご選択ください。</span>';
    }
    return $send_date;
}
/**
*
* 希望配送時間フォーム
*
*/
function SendTime($confs)
{
    $send_time_array = explode(',', $confs['send_time']);
    $send_time_array = showEscap($send_time_array);

    $html = '';
    if (count($send_time_array)) {
        $html .= '<select name="send_time">'."\n";
        $html .= '<option value=""></option>'."\n";
        foreach ($send_time_array as $val) {
            $html .= '<option value="'.$val.'">'.$val.'</option>'."\n";
        }
        $html .= '</select>'."\n";
    }
    return $html;
}

/**
*
* 支払方法フォーム
*
*/
function PayType($confs)
{
    $pay_type_array = explode(',', $confs['pay_type']);
    $pay_type_array = showEscap($pay_type_array);

    $html = '';
    if (count($pay_type_array)) {
        $html .= '<select name="pay_type">'."\n";
        $html .= '<option value=""></option>'."\n";
        foreach ($pay_type_array as $val) {
            $html .= '<option value="'.$val.'">'.$val.'</option>'."\n";
        }
        $html .= '</select>'."\n";
    }
    return $html;
}

function OrderForm($confs, $md, $forms, $items = array())
{
    $order_form = (int)$confs['order_form'];
    $html = '';

    if ($order_form > 0) {
        if ($md == 'input' || $md == 'confirm') {
            $html .= '<div class="border0">'."\n";
            $html .= '<table>'."\n";
            $html .= '<tr>'."\n";
            $html .= '<th>'.showEscap($confs['item_caption']).'</th><th>&nbsp;</th><th>数量</th>'."\n";
            $html .= '</tr>'."\n";

            $j = 0;
            for ($i = 0; $i < $order_form; $i++) {
                if ($md == 'confirm') {
                    if ($forms['item_count']['value'][$i]) {
                        $html .= '<tr>'."\n";
                        $html .= '<td>'.showEscap($forms['item_name']['value'][$i]).'</td>'."\n";
                        $html .= '<td> - </td>'."\n";
                        $html .= '<td>'.showEscap($forms['item_count']['value'][$i]).'</td>'."\n";
                        $html .= '</tr>'."\n";
                    }
                } else {
                    if (!isset($items['item_name'][$i])) {
                        $items['item_name'][$i] = '';
                    }
                    $j++;
                    $html .= '<tr>'."\n";
                    $html .= '<td>['.$j.'] <input type="text" name="item_name[]" value="'.$items['item_name'][$i].'"></td>'."\n";
                    $html .= '<td> - </td>'."\n";
                    $html .= '<td><input type="text" name="item_count[]" size="3" value="'.$items['item_count'][$i].'"></td>'."\n";
                    $html .= '</tr>'."\n";
                }
            }
            $html .= '</table>'."\n";
            if ($md == 'input') {
                $html .= '<span class="small">数量は半角数字。<br>同じ段が対になるようご記入ください。</span>'."\n";
            }
            $html .= '</div>'."\n";
            return $html;
        } elseif ($md == 'send') {
            $body = '（ '.$confs['item_caption'].' ： 数量 ）'."\n";
            for ($i = 0; $i < $order_form; $i++) {
                if (isset($forms['item_count']['value'][$i]) && $forms['item_count']['value'][$i]) {
                    $body .= $forms['item_name']['value'][$i].' ： '.$forms['item_count']['value'][$i]."\n";
                }
            }
            return $body;
        }
    }
}


/**
*
* 任意項目フォーム
*
*/
function OptionalForm($confs, $md, $forms = '')
{
    $html = '';

    // 値分割
    if ($confs['optional_value']) {
        $values = explode(',', $confs['optional_value']);
        $values = showEscap($values);
    }

    if ($md == 'input') {
        if ($confs['optional_type'] == 'radio') {
            for ($i = 0; $i < count($values); $i++) {
                $html .= '<input type="radio" name="optional" value="'.$values[$i].'" id="'.$i.'"><label for="'.$i.'"> '.$values[$i].'</label> '."\n";
            }
        } elseif ($confs['optional_type'] == 'checkbox') {
            for ($i = 0; $i < count($values); $i++) {
                $html .= '<input type="checkbox" name="optional[]" value="'.$values[$i].'" id="'.$i.'"><label for="'.$i.'"> '.$values[$i].'</label> '."\n";
            }
        } elseif ($confs['optional_type'] == 'select') {
            $html .= '<select name="optional">'."\n";
            $html .= '<option value=""></option>'."\n";
            for ($i = 0; $i < count($values); $i++) {
                $html .= '<option value="'.$values[$i].'">'.$values[$i].'</option>'."\n";
            }
            $html .= '</select>'."\n";
        } elseif ($confs['optional_type'] == 'text') {
            $html .= '<input type="text" name="optional" value="" size="30">'."\n";
        } elseif ($confs['optional_type'] == 'textarea') {
            $html .= '<textarea name="optional" cols="40" rows="4"></textarea>'."\n";
        }
    } elseif ($md == 'confirm') {
        if ($confs['optional_type'] == 'radio' || $confs['optional_type'] == 'select' || $confs['optional_type'] == 'text' || $confs['optional_type'] == 'textarea') {
            $html .= $forms['optional']['value']."\n";
        } elseif ($confs['optional_type'] == 'checkbox') {
            for ($i = 0; $i < count($forms['optional']['value']); $i++) {
                if ($forms['optional']['value'][$i]) {
                    $html .= $forms['optional']['value'][$i].' ';
                }
            }
        }
    } elseif ($md == 'send') {
        if ($confs['optional_type'] == 'radio' || $confs['optional_type'] == 'select' || $confs['optional_type'] == 'text' || $confs['optional_type'] == 'textarea') {
            $html .= $forms['optional']['value']."\n";
        } elseif ($confs['optional_type'] == 'checkbox') {
            for ($i = 0; $i < count($forms['optional']['value']); $i++) {
                if ($forms['optional']['value'][$i]) {
                    $html .= $forms['optional']['value'][$i].' ';
                }
            }
        }
    }
    return $html;
}

/**
*
* メール送信
*
*/
function mailSend($to, $subject, $body, $from, $bcc = '', $ml_option = 0, $j_from = '')
{
    if ($ml_option) {
        $ml_option = "-f ".$from;
    }
    // header 作成
    if ($j_from) {
        $j_from = mb_encode_mimeheader($j_from);
        $from = $j_from.' <'.$from.'>';
    }
    $head = "From: ".$from."\r\n";
    if ($bcc) {
        $head .= "Bcc: ".$bcc."\r\n";
    }
    $head .= "Reply-To: ".$from."\r\n";
    $head .= "X-Mailer: PHP/".phpversion()."\r\n";
    $head .= "MIME-Version: 1.0\r\n";
    $head .= "Content-Type: text/plain; charset=ISO-2022-JP\r\n";
    $head .= "Content-Transfer-Encoding: 7bit";

    if ($subject) {
        $subject = "=?iso-2022-jp?B?".base64_encode(mb_convert_encoding($subject, "JIS", "auto"))."?=";
    }

    $body = preg_replace("/\r/", "\n", $body);
    $body = preg_replace("/\r/", "\n", $body);
    $body = mb_convert_encoding($body, "JIS", "auto");

    if (SAMPLE == true) {
        return true;
    }

    if ($ml_option) {
        $re = @mail($to, $subject, $body, $head, $ml_option);
    } else {
        $re = @mail($to, $subject, $body, $head);
    }
    return $re;
}

/**
*
* validateでカバーできないその他の入力値チェック
*
*/
function checkOther($forms, $confs)
{
    $errors = [];

    // 配送日
    if ($forms['send_date_y']['value'] || $forms['send_date_m']['value'] || $forms['send_date_d']['value']) {
        if ($forms['send_date_y']['value'] == '' || $forms['send_date_m']['value'] == '' || $forms['send_date_d']['value'] == '') {
            $errors[] = 'ご希望配送日は 年月日 全てご選択ください。';
        } else {
            $start = date("Ymd", time() + (60 * 60 * 24 * $confs['send_date_start']));
            $end   = date("Ymd", time() + (60 * 60 * 24 * $confs['send_date_end']));
            $target = sprintf("%04d", $forms['send_date_y']['value']).sprintf("%02d", $forms['send_date_m']['value']).sprintf("%02d", $forms['send_date_d']['value']);
            if (($confs['send_date_start'] != '' && $target < $start) || ($confs['send_date_end'] != '' && $target > $end)) {
                $errors[] = 'ご希望配送日は本日より'.(int)$confs['send_date_start'].'日以降'.(int)$confs['send_date_end'].'日以前でご選択ください。';
            }
        }
    }
    // 商品
    for ($i = 0; $i < $confs['order_form']; $i++) {
        if (isset($forms['item_count']['value'][$i]) && $forms['item_name']['value'][$i] != '') {
            if (!$forms['item_count']['value'][$i]) {
                $errors[] = 'ご注文['.($i + 1).']の数量を入力してください。';
            }
        }
        if (isset($forms['item_count']['value'][$i]) && $forms['item_count']['value'][$i]) {
            if ($forms['item_name']['value'][$i] == '') {
                $errors[] = 'ご注文['.($i + 1).']の商品を入力してください。';
            }
        }
    }
    // 送付先情報
    if ($forms['dist_name'] != '' || $forms['dist_name_kana'] != '' || $forms['dist_postal'] != '' || $forms['dist_address'] != '' || $forms['dist_tel'] != '') {
        if (
            ($forms['dist_name'] == '' && $confs['show_dist_name']) ||
            ($forms['dist_name_kana'] == '' && $confs['show_dist_name_kana']) ||
            ($forms['dist_postal'] == '' && $confs['show_dist_postal']) ||
            ($forms['dist_address'] == '' && $confs['show_dist_address']) ||
            ($forms['dist_tel'] == '' && $confs['show_dist_tel'])
        ) {
            $errors[] = '送付先をご入力する場合は送付先情報全てご入力ください。';
        }
    }
    return $errors;
}

/**
*
* CSS
*
*/
function cssMail($confs)
{
    // 位置
    if ($confs['place'] == 1) {
        $body = 'center';
        $contents = '0px auto';
    } else {
        $body = 'left';
        $contents = '';
    }

    // エスケープ
    $confs = showEscap($confs);

    $css = <<<CSS
body {
    font-size: {$confs['font_size']}px;
    color: #{$confs['font_color']};
    text-align: {$body};
    background-color: #{$confs['bgcolor_body']};
}
.contents {
    margin: {$contents};
    text-align: left;
    width: {$confs['width']}px;
}
.contents h1 {
    text-align: center;
    font-size: {$confs['font_size_title']}px;
    margin-top: 20px;
}
.contents table {
    font-size: {$confs['font_size']}px;
    border-collapse: collapse;
}
.contents textarea {
    font-size: {$confs['font_size']}px;
    width: 350px;
}
form {
    margin: 0px;
}
.btn_l {
    width: 120px;
}
.mail_t {
    width: 100%;
}
.mail_t table {
	width: 100%;
}
.mail_t th {
    width: 30%;
	font-weight: normal;
	background-color: #{$confs['bgcolor_th']};
	padding: 4px;
	border: solid 1px #{$confs['border_form']};
	text-align: right;
}
.mail_t td {
    width: 70%;
    background-color: #{$confs['bgcolor_td']};
	padding: 4px;
	border: solid 1px #{$confs['border_form']};
}
.border0 table {
    width: auto;
}
.border0 th {
    border: none;
    width: auto;
    background-color: #{$confs['bgcolor_td']};
    text-align: center;
}
.border0 td {
    border: none;
    width: auto;
    background-color: #{$confs['bgcolor_td']};
}
.right {
    text-align: right;
}
.center {
    text-align: center;
}
.attention {
    color: #f33;
}
.error {
    color: #f33;
}
.small {
    font-size: 10px;
    color: #36f;
    letter-spacing: 1px;
}
.progress {
    text-align: center;
}
.progress span {
    margin: 0px 20px;
    padding: 2px 30px;
    background-color: #eee;
    border: solid 1px #ccc;
}
#active {
    background-color: #f99;
    color: #fff;
    font-weight: bold;
}
.imeoff {
    ime-mode: disabled;
}

CSS;
    return $css;
}
